varying vec3 normal;   // vertex normal in eye space.
varying vec3 position; // vertex position in eye space.
varying vec3 nor;
varying vec3 vertex;
varying vec4 v_position;

uniform float angle_deg_max;
uniform float height;

vec4 DoTwist( vec4 pos, float t )
{
	float st = sin(t);
	float ct = cos(t);
	vec4 new_pos;
	
	new_pos.x = pos.x*ct - pos.z*st;
	new_pos.z = pos.x*st + pos.z*ct;
	
	new_pos.y = pos.y;
	new_pos.w = pos.w;

	return( new_pos );
}



void main( void )
{
	float angle_deg = angle_deg_max; // *sin(time);
	float angle_rad = angle_deg * 3.14159 / 180.0;
	
	float ang = (height*0.5 + gl_Vertex.y)/height * angle_rad;

	vec4 twistedPosition = DoTwist(gl_Vertex, ang);
	vec4 twistedNormal = DoTwist(vec4(gl_Normal, 1), ang); 


 	v_position=(gl_ModelViewProjectionMatrix*twistedPosition);
	gl_Position = v_position;
	gl_TexCoord[0] = gl_MultiTexCoord0;

	normal = gl_NormalMatrix * twistedNormal.xyz;
	nor=twistedNormal.xyz;
	position = ( gl_ModelViewMatrix * gl_Vertex ).xyz;
	vertex=gl_Vertex.xyz;
	gl_FrontColor  = gl_Color;

}


